package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{Percentage, AwsRegion}
import scala.jdk.CollectionConverters._
final case class Distribution(region: AwsRegion, percentage: Percentage) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Distribution = {
    import Distribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Distribution
      .builder()
      .region(AwsRegion.unwrap(region): java.lang.String)
      .percentage(Percentage.unwrap(percentage): Integer)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Distribution.ReadOnly =
    zio.aws.connect.model.Distribution.wrap(buildAwsValue())
}
object Distribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.Distribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Distribution =
      zio.aws.connect.model.Distribution(region, percentage)
    def region: AwsRegion
    def percentage: Percentage
    def getRegion: ZIO[Any, Nothing, AwsRegion] = ZIO.succeed(region)
    def getPercentage: ZIO[Any, Nothing, Percentage] = ZIO.succeed(percentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Distribution
  ) extends zio.aws.connect.model.Distribution.ReadOnly {
    override val region: AwsRegion =
      zio.aws.connect.model.primitives.AwsRegion(impl.region())
    override val percentage: Percentage =
      zio.aws.connect.model.primitives.Percentage(impl.percentage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Distribution
  ): zio.aws.connect.model.Distribution.ReadOnly = new Wrapper(impl)
}
