package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.connect.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.EncryptionType
  ): zio.aws.connect.model.EncryptionType = value match {
    case software.amazon.awssdk.services.connect.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.EncryptionType.KMS =>
      val r = KMS
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EncryptionType =
      software.amazon.awssdk.services.connect.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object KMS extends zio.aws.connect.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EncryptionType =
      software.amazon.awssdk.services.connect.model.EncryptionType.KMS
  }
}
