package zio.aws.connect.model
import zio.aws.connect.model.primitives.{MaxResult100, NextToken, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetCurrentMetricDataRequest(
    instanceId: InstanceId,
    filters: zio.aws.connect.model.Filters,
    groupings: Optional[Iterable[zio.aws.connect.model.Grouping]] =
      Optional.Absent,
    currentMetrics: Iterable[zio.aws.connect.model.CurrentMetric],
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest = {
    import GetCurrentMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .filters(filters.buildAwsValue())
      .optionallyWith(
        groupings.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.groupingsWithStrings)
      .currentMetrics(currentMetrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetCurrentMetricDataRequest.ReadOnly =
    zio.aws.connect.model.GetCurrentMetricDataRequest.wrap(buildAwsValue())
}
object GetCurrentMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetCurrentMetricDataRequest =
      zio.aws.connect.model.GetCurrentMetricDataRequest(
        instanceId,
        filters.asEditable,
        groupings.map(value => value),
        currentMetrics.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def filters: zio.aws.connect.model.Filters.ReadOnly
    def groupings: Optional[List[zio.aws.connect.model.Grouping]]
    def currentMetrics: List[zio.aws.connect.model.CurrentMetric.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult100]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getFilters: ZIO[Any, Nothing, zio.aws.connect.model.Filters.ReadOnly] =
      ZIO.succeed(filters)
    def getGroupings: ZIO[Any, AwsError, List[zio.aws.connect.model.Grouping]] =
      AwsError.unwrapOptionField("groupings", groupings)
    def getCurrentMetrics: ZIO[Any, Nothing, List[
      zio.aws.connect.model.CurrentMetric.ReadOnly
    ]] = ZIO.succeed(currentMetrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest
  ) extends zio.aws.connect.model.GetCurrentMetricDataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val filters: zio.aws.connect.model.Filters.ReadOnly =
      zio.aws.connect.model.Filters.wrap(impl.filters())
    override val groupings: Optional[List[zio.aws.connect.model.Grouping]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.Grouping.wrap(item)
          }.toList
        )
    override val currentMetrics
        : List[zio.aws.connect.model.CurrentMetric.ReadOnly] = impl
      .currentMetrics()
      .asScala
      .map { item =>
        zio.aws.connect.model.CurrentMetric.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest
  ): zio.aws.connect.model.GetCurrentMetricDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
