package zio.aws.connect.model
import zio.aws.connect.model.primitives.{Timestamp, NextToken}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetCurrentMetricDataResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    metricResults: Optional[
      Iterable[zio.aws.connect.model.CurrentMetricResult]
    ] = Optional.Absent,
    dataSnapshotTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse = {
    import GetCurrentMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        metricResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricResults)
      .optionallyWith(
        dataSnapshotTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataSnapshotTime)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly =
    zio.aws.connect.model.GetCurrentMetricDataResponse.wrap(buildAwsValue())
}
object GetCurrentMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetCurrentMetricDataResponse =
      zio.aws.connect.model.GetCurrentMetricDataResponse(
        nextToken.map(value => value),
        metricResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSnapshotTime.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def metricResults
        : Optional[List[zio.aws.connect.model.CurrentMetricResult.ReadOnly]]
    def dataSnapshotTime: Optional[Timestamp]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMetricResults: ZIO[Any, AwsError, List[
      zio.aws.connect.model.CurrentMetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricResults", metricResults)
    def getDataSnapshotTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataSnapshotTime", dataSnapshotTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
  ) extends zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val metricResults
        : Optional[List[zio.aws.connect.model.CurrentMetricResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.CurrentMetricResult.wrap(item)
          }.toList
        )
    override val dataSnapshotTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSnapshotTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
  ): zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
