package zio.aws.connect.model
import zio.aws.connect.model.primitives.{MaxResult100, NextToken, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetCurrentUserDataRequest(
    instanceId: InstanceId,
    filters: zio.aws.connect.model.UserDataFilters,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest = {
    import GetCurrentUserDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .filters(filters.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetCurrentUserDataRequest.ReadOnly =
    zio.aws.connect.model.GetCurrentUserDataRequest.wrap(buildAwsValue())
}
object GetCurrentUserDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetCurrentUserDataRequest =
      zio.aws.connect.model.GetCurrentUserDataRequest(
        instanceId,
        filters.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def filters: zio.aws.connect.model.UserDataFilters.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult100]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getFilters
        : ZIO[Any, Nothing, zio.aws.connect.model.UserDataFilters.ReadOnly] =
      ZIO.succeed(filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest
  ) extends zio.aws.connect.model.GetCurrentUserDataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val filters: zio.aws.connect.model.UserDataFilters.ReadOnly =
      zio.aws.connect.model.UserDataFilters.wrap(impl.filters())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest
  ): zio.aws.connect.model.GetCurrentUserDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
