package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFederationTokenResponse(
    credentials: Optional[zio.aws.connect.model.Credentials] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetFederationTokenResponse = {
    import GetFederationTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetFederationTokenResponse.ReadOnly =
    zio.aws.connect.model.GetFederationTokenResponse.wrap(buildAwsValue())
}
object GetFederationTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetFederationTokenResponse =
      zio.aws.connect.model
        .GetFederationTokenResponse(credentials.map(value => value.asEditable))
    def credentials: Optional[zio.aws.connect.model.Credentials.ReadOnly]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.connect.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
  ) extends zio.aws.connect.model.GetFederationTokenResponse.ReadOnly {
    override val credentials
        : Optional[zio.aws.connect.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.connect.model.Credentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
  ): zio.aws.connect.model.GetFederationTokenResponse.ReadOnly = new Wrapper(
    impl
  )
}
