package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResult100,
  NextToken,
  Timestamp,
  InstanceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetMetricDataRequest(
    instanceId: InstanceId,
    startTime: Timestamp,
    endTime: Timestamp,
    filters: zio.aws.connect.model.Filters,
    groupings: Optional[Iterable[zio.aws.connect.model.Grouping]] =
      Optional.Absent,
    historicalMetrics: Iterable[zio.aws.connect.model.HistoricalMetric],
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetMetricDataRequest = {
    import GetMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetMetricDataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .filters(filters.buildAwsValue())
      .optionallyWith(
        groupings.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.groupingsWithStrings)
      .historicalMetrics(historicalMetrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetMetricDataRequest.ReadOnly =
    zio.aws.connect.model.GetMetricDataRequest.wrap(buildAwsValue())
}
object GetMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetMetricDataRequest =
      zio.aws.connect.model.GetMetricDataRequest(
        instanceId,
        startTime,
        endTime,
        filters.asEditable,
        groupings.map(value => value),
        historicalMetrics.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def startTime: Timestamp
    def endTime: Timestamp
    def filters: zio.aws.connect.model.Filters.ReadOnly
    def groupings: Optional[List[zio.aws.connect.model.Grouping]]
    def historicalMetrics: List[zio.aws.connect.model.HistoricalMetric.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult100]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getFilters: ZIO[Any, Nothing, zio.aws.connect.model.Filters.ReadOnly] =
      ZIO.succeed(filters)
    def getGroupings: ZIO[Any, AwsError, List[zio.aws.connect.model.Grouping]] =
      AwsError.unwrapOptionField("groupings", groupings)
    def getHistoricalMetrics: ZIO[Any, Nothing, List[
      zio.aws.connect.model.HistoricalMetric.ReadOnly
    ]] = ZIO.succeed(historicalMetrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataRequest
  ) extends zio.aws.connect.model.GetMetricDataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val startTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.endTime())
    override val filters: zio.aws.connect.model.Filters.ReadOnly =
      zio.aws.connect.model.Filters.wrap(impl.filters())
    override val groupings: Optional[List[zio.aws.connect.model.Grouping]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.Grouping.wrap(item)
          }.toList
        )
    override val historicalMetrics
        : List[zio.aws.connect.model.HistoricalMetric.ReadOnly] = impl
      .historicalMetrics()
      .asScala
      .map { item =>
        zio.aws.connect.model.HistoricalMetric.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataRequest
  ): zio.aws.connect.model.GetMetricDataRequest.ReadOnly = new Wrapper(impl)
}
