package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.TrafficDistributionGroupIdOrArn
import scala.jdk.CollectionConverters._
final case class GetTrafficDistributionRequest(
    id: TrafficDistributionGroupIdOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest = {
    import GetTrafficDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest
      .builder()
      .id(TrafficDistributionGroupIdOrArn.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetTrafficDistributionRequest.ReadOnly =
    zio.aws.connect.model.GetTrafficDistributionRequest.wrap(buildAwsValue())
}
object GetTrafficDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetTrafficDistributionRequest =
      zio.aws.connect.model.GetTrafficDistributionRequest(id)
    def id: TrafficDistributionGroupIdOrArn
    def getId: ZIO[Any, Nothing, TrafficDistributionGroupIdOrArn] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest
  ) extends zio.aws.connect.model.GetTrafficDistributionRequest.ReadOnly {
    override val id: TrafficDistributionGroupIdOrArn =
      zio.aws.connect.model.primitives
        .TrafficDistributionGroupIdOrArn(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest
  ): zio.aws.connect.model.GetTrafficDistributionRequest.ReadOnly = new Wrapper(
    impl
  )
}
