package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HierarchyGroupCondition(
    value: Optional[String] = Optional.Absent,
    hierarchyGroupMatchType: Optional[
      zio.aws.connect.model.HierarchyGroupMatchType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyGroupCondition = {
    import HierarchyGroupCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyGroupCondition
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(hierarchyGroupMatchType.map(value => value.unwrap))(
        _.hierarchyGroupMatchType
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyGroupCondition.ReadOnly =
    zio.aws.connect.model.HierarchyGroupCondition.wrap(buildAwsValue())
}
object HierarchyGroupCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyGroupCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyGroupCondition =
      zio.aws.connect.model.HierarchyGroupCondition(
        value.map(value => value),
        hierarchyGroupMatchType.map(value => value)
      )
    def value: Optional[String]
    def hierarchyGroupMatchType
        : Optional[zio.aws.connect.model.HierarchyGroupMatchType]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getHierarchyGroupMatchType
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyGroupMatchType] =
      AwsError.unwrapOptionField(
        "hierarchyGroupMatchType",
        hierarchyGroupMatchType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupCondition
  ) extends zio.aws.connect.model.HierarchyGroupCondition.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val hierarchyGroupMatchType
        : Optional[zio.aws.connect.model.HierarchyGroupMatchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyGroupMatchType())
        .map(value => zio.aws.connect.model.HierarchyGroupMatchType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupCondition
  ): zio.aws.connect.model.HierarchyGroupCondition.ReadOnly = new Wrapper(impl)
}
