package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  HierarchyGroupName,
  ARN,
  HierarchyGroupId
}
import scala.jdk.CollectionConverters._
final case class HierarchyGroupSummary(
    id: Optional[HierarchyGroupId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[HierarchyGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyGroupSummary = {
    import HierarchyGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
      .builder()
      .optionallyWith(
        id.map(value => HierarchyGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => HierarchyGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyGroupSummary.ReadOnly =
    zio.aws.connect.model.HierarchyGroupSummary.wrap(buildAwsValue())
}
object HierarchyGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyGroupSummary =
      zio.aws.connect.model.HierarchyGroupSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Optional[HierarchyGroupId]
    def arn: Optional[ARN]
    def name: Optional[HierarchyGroupName]
    def getId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, HierarchyGroupName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
  ) extends zio.aws.connect.model.HierarchyGroupSummary.ReadOnly {
    override val id: Optional[HierarchyGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[HierarchyGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
  ): zio.aws.connect.model.HierarchyGroupSummary.ReadOnly = new Wrapper(impl)
}
