package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, HierarchyGroupId}
import scala.jdk.CollectionConverters._
final case class HierarchyGroupSummaryReference(
    id: Optional[HierarchyGroupId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyGroupSummaryReference = {
    import HierarchyGroupSummaryReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyGroupSummaryReference
      .builder()
      .optionallyWith(
        id.map(value => HierarchyGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.HierarchyGroupSummaryReference.ReadOnly =
    zio.aws.connect.model.HierarchyGroupSummaryReference.wrap(buildAwsValue())
}
object HierarchyGroupSummaryReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyGroupSummaryReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyGroupSummaryReference =
      zio.aws.connect.model.HierarchyGroupSummaryReference(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[HierarchyGroupId]
    def arn: Optional[ARN]
    def getId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupSummaryReference
  ) extends zio.aws.connect.model.HierarchyGroupSummaryReference.ReadOnly {
    override val id: Optional[HierarchyGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupSummaryReference
  ): zio.aws.connect.model.HierarchyGroupSummaryReference.ReadOnly =
    new Wrapper(impl)
}
