package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HierarchyStructure(
    levelOne: Optional[zio.aws.connect.model.HierarchyLevel] = Optional.Absent,
    levelTwo: Optional[zio.aws.connect.model.HierarchyLevel] = Optional.Absent,
    levelThree: Optional[zio.aws.connect.model.HierarchyLevel] =
      Optional.Absent,
    levelFour: Optional[zio.aws.connect.model.HierarchyLevel] = Optional.Absent,
    levelFive: Optional[zio.aws.connect.model.HierarchyLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyStructure = {
    import HierarchyStructure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyStructure
      .builder()
      .optionallyWith(levelOne.map(value => value.buildAwsValue()))(_.levelOne)
      .optionallyWith(levelTwo.map(value => value.buildAwsValue()))(_.levelTwo)
      .optionallyWith(levelThree.map(value => value.buildAwsValue()))(
        _.levelThree
      )
      .optionallyWith(levelFour.map(value => value.buildAwsValue()))(
        _.levelFour
      )
      .optionallyWith(levelFive.map(value => value.buildAwsValue()))(
        _.levelFive
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyStructure.ReadOnly =
    zio.aws.connect.model.HierarchyStructure.wrap(buildAwsValue())
}
object HierarchyStructure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyStructure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyStructure =
      zio.aws.connect.model.HierarchyStructure(
        levelOne.map(value => value.asEditable),
        levelTwo.map(value => value.asEditable),
        levelThree.map(value => value.asEditable),
        levelFour.map(value => value.asEditable),
        levelFive.map(value => value.asEditable)
      )
    def levelOne: Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly]
    def levelTwo: Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly]
    def levelThree: Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly]
    def levelFour: Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly]
    def levelFive: Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly]
    def getLevelOne
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      AwsError.unwrapOptionField("levelOne", levelOne)
    def getLevelTwo
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      AwsError.unwrapOptionField("levelTwo", levelTwo)
    def getLevelThree
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      AwsError.unwrapOptionField("levelThree", levelThree)
    def getLevelFour
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      AwsError.unwrapOptionField("levelFour", levelFour)
    def getLevelFive
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      AwsError.unwrapOptionField("levelFive", levelFive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyStructure
  ) extends zio.aws.connect.model.HierarchyStructure.ReadOnly {
    override val levelOne
        : Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.levelOne())
        .map(value => zio.aws.connect.model.HierarchyLevel.wrap(value))
    override val levelTwo
        : Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.levelTwo())
        .map(value => zio.aws.connect.model.HierarchyLevel.wrap(value))
    override val levelThree
        : Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.levelThree())
        .map(value => zio.aws.connect.model.HierarchyLevel.wrap(value))
    override val levelFour
        : Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.levelFour())
        .map(value => zio.aws.connect.model.HierarchyLevel.wrap(value))
    override val levelFive
        : Optional[zio.aws.connect.model.HierarchyLevel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.levelFive())
        .map(value => zio.aws.connect.model.HierarchyLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyStructure
  ): zio.aws.connect.model.HierarchyStructure.ReadOnly = new Wrapper(impl)
}
