package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HistoricalMetric(
    name: Optional[zio.aws.connect.model.HistoricalMetricName] =
      Optional.Absent,
    threshold: Optional[zio.aws.connect.model.Threshold] = Optional.Absent,
    statistic: Optional[zio.aws.connect.model.Statistic] = Optional.Absent,
    unit: Optional[zio.aws.connect.model.Unit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HistoricalMetric = {
    import HistoricalMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HistoricalMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(threshold.map(value => value.buildAwsValue()))(
        _.threshold
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HistoricalMetric.ReadOnly =
    zio.aws.connect.model.HistoricalMetric.wrap(buildAwsValue())
}
object HistoricalMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HistoricalMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HistoricalMetric =
      zio.aws.connect.model.HistoricalMetric(
        name.map(value => value),
        threshold.map(value => value.asEditable),
        statistic.map(value => value),
        unit.map(value => value)
      )
    def name: Optional[zio.aws.connect.model.HistoricalMetricName]
    def threshold: Optional[zio.aws.connect.model.Threshold.ReadOnly]
    def statistic: Optional[zio.aws.connect.model.Statistic]
    def unit: Optional[zio.aws.connect.model.Unit]
    def getName
        : ZIO[Any, AwsError, zio.aws.connect.model.HistoricalMetricName] =
      AwsError.unwrapOptionField("name", name)
    def getThreshold
        : ZIO[Any, AwsError, zio.aws.connect.model.Threshold.ReadOnly] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getStatistic: ZIO[Any, AwsError, zio.aws.connect.model.Statistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getUnit: ZIO[Any, AwsError, zio.aws.connect.model.Unit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetric
  ) extends zio.aws.connect.model.HistoricalMetric.ReadOnly {
    override val name: Optional[zio.aws.connect.model.HistoricalMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.connect.model.HistoricalMetricName.wrap(value))
    override val threshold: Optional[zio.aws.connect.model.Threshold.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threshold())
        .map(value => zio.aws.connect.model.Threshold.wrap(value))
    override val statistic: Optional[zio.aws.connect.model.Statistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.connect.model.Statistic.wrap(value))
    override val unit: Optional[zio.aws.connect.model.Unit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.connect.model.Unit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetric
  ): zio.aws.connect.model.HistoricalMetric.ReadOnly = new Wrapper(impl)
}
