package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HoursOfOperationConfig(
    day: zio.aws.connect.model.HoursOfOperationDays,
    startTime: zio.aws.connect.model.HoursOfOperationTimeSlice,
    endTime: zio.aws.connect.model.HoursOfOperationTimeSlice
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HoursOfOperationConfig = {
    import HoursOfOperationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HoursOfOperationConfig
      .builder()
      .day(day.unwrap)
      .startTime(startTime.buildAwsValue())
      .endTime(endTime.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HoursOfOperationConfig.ReadOnly =
    zio.aws.connect.model.HoursOfOperationConfig.wrap(buildAwsValue())
}
object HoursOfOperationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HoursOfOperationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HoursOfOperationConfig =
      zio.aws.connect.model
        .HoursOfOperationConfig(day, startTime.asEditable, endTime.asEditable)
    def day: zio.aws.connect.model.HoursOfOperationDays
    def startTime: zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly
    def endTime: zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly
    def getDay: ZIO[Any, Nothing, zio.aws.connect.model.HoursOfOperationDays] =
      ZIO.succeed(day)
    def getStartTime: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly
    ] = ZIO.succeed(startTime)
    def getEndTime: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly
    ] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationConfig
  ) extends zio.aws.connect.model.HoursOfOperationConfig.ReadOnly {
    override val day: zio.aws.connect.model.HoursOfOperationDays =
      zio.aws.connect.model.HoursOfOperationDays.wrap(impl.day())
    override val startTime
        : zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly =
      zio.aws.connect.model.HoursOfOperationTimeSlice.wrap(impl.startTime())
    override val endTime
        : zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly =
      zio.aws.connect.model.HoursOfOperationTimeSlice.wrap(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationConfig
  ): zio.aws.connect.model.HoursOfOperationConfig.ReadOnly = new Wrapper(impl)
}
