package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{MinutesLimit60, Hours24Format}
import scala.jdk.CollectionConverters._
final case class HoursOfOperationTimeSlice(
    hours: Hours24Format,
    minutes: MinutesLimit60
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HoursOfOperationTimeSlice = {
    import HoursOfOperationTimeSlice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HoursOfOperationTimeSlice
      .builder()
      .hours(Hours24Format.unwrap(hours): Integer)
      .minutes(MinutesLimit60.unwrap(minutes): Integer)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly =
    zio.aws.connect.model.HoursOfOperationTimeSlice.wrap(buildAwsValue())
}
object HoursOfOperationTimeSlice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HoursOfOperationTimeSlice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HoursOfOperationTimeSlice =
      zio.aws.connect.model.HoursOfOperationTimeSlice(hours, minutes)
    def hours: Hours24Format
    def minutes: MinutesLimit60
    def getHours: ZIO[Any, Nothing, Hours24Format] = ZIO.succeed(hours)
    def getMinutes: ZIO[Any, Nothing, MinutesLimit60] = ZIO.succeed(minutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationTimeSlice
  ) extends zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly {
    override val hours: Hours24Format =
      zio.aws.connect.model.primitives.Hours24Format(impl.hours())
    override val minutes: MinutesLimit60 =
      zio.aws.connect.model.primitives.MinutesLimit60(impl.minutes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationTimeSlice
  ): zio.aws.connect.model.HoursOfOperationTimeSlice.ReadOnly = new Wrapper(
    impl
  )
}
