package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.AssociationId
import scala.jdk.CollectionConverters._
final case class InstanceStorageConfig(
    associationId: Optional[AssociationId] = Optional.Absent,
    storageType: zio.aws.connect.model.StorageType,
    s3Config: Optional[zio.aws.connect.model.S3Config] = Optional.Absent,
    kinesisVideoStreamConfig: Optional[
      zio.aws.connect.model.KinesisVideoStreamConfig
    ] = Optional.Absent,
    kinesisStreamConfig: Optional[zio.aws.connect.model.KinesisStreamConfig] =
      Optional.Absent,
    kinesisFirehoseConfig: Optional[
      zio.aws.connect.model.KinesisFirehoseConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.InstanceStorageConfig = {
    import InstanceStorageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.InstanceStorageConfig
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .storageType(storageType.unwrap)
      .optionallyWith(s3Config.map(value => value.buildAwsValue()))(_.s3Config)
      .optionallyWith(
        kinesisVideoStreamConfig.map(value => value.buildAwsValue())
      )(_.kinesisVideoStreamConfig)
      .optionallyWith(kinesisStreamConfig.map(value => value.buildAwsValue()))(
        _.kinesisStreamConfig
      )
      .optionallyWith(
        kinesisFirehoseConfig.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseConfig)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.InstanceStorageConfig.ReadOnly =
    zio.aws.connect.model.InstanceStorageConfig.wrap(buildAwsValue())
}
object InstanceStorageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.InstanceStorageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.InstanceStorageConfig =
      zio.aws.connect.model.InstanceStorageConfig(
        associationId.map(value => value),
        storageType,
        s3Config.map(value => value.asEditable),
        kinesisVideoStreamConfig.map(value => value.asEditable),
        kinesisStreamConfig.map(value => value.asEditable),
        kinesisFirehoseConfig.map(value => value.asEditable)
      )
    def associationId: Optional[AssociationId]
    def storageType: zio.aws.connect.model.StorageType
    def s3Config: Optional[zio.aws.connect.model.S3Config.ReadOnly]
    def kinesisVideoStreamConfig
        : Optional[zio.aws.connect.model.KinesisVideoStreamConfig.ReadOnly]
    def kinesisStreamConfig
        : Optional[zio.aws.connect.model.KinesisStreamConfig.ReadOnly]
    def kinesisFirehoseConfig
        : Optional[zio.aws.connect.model.KinesisFirehoseConfig.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getStorageType: ZIO[Any, Nothing, zio.aws.connect.model.StorageType] =
      ZIO.succeed(storageType)
    def getS3Config
        : ZIO[Any, AwsError, zio.aws.connect.model.S3Config.ReadOnly] =
      AwsError.unwrapOptionField("s3Config", s3Config)
    def getKinesisVideoStreamConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.KinesisVideoStreamConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamConfig",
      kinesisVideoStreamConfig
    )
    def getKinesisStreamConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.KinesisStreamConfig.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisStreamConfig", kinesisStreamConfig)
    def getKinesisFirehoseConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.KinesisFirehoseConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("kinesisFirehoseConfig", kinesisFirehoseConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.InstanceStorageConfig
  ) extends zio.aws.connect.model.InstanceStorageConfig.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.connect.model.primitives.AssociationId(value))
    override val storageType: zio.aws.connect.model.StorageType =
      zio.aws.connect.model.StorageType.wrap(impl.storageType())
    override val s3Config: Optional[zio.aws.connect.model.S3Config.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Config())
        .map(value => zio.aws.connect.model.S3Config.wrap(value))
    override val kinesisVideoStreamConfig
        : Optional[zio.aws.connect.model.KinesisVideoStreamConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisVideoStreamConfig())
        .map(value =>
          zio.aws.connect.model.KinesisVideoStreamConfig.wrap(value)
        )
    override val kinesisStreamConfig
        : Optional[zio.aws.connect.model.KinesisStreamConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisStreamConfig())
        .map(value => zio.aws.connect.model.KinesisStreamConfig.wrap(value))
    override val kinesisFirehoseConfig
        : Optional[zio.aws.connect.model.KinesisFirehoseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisFirehoseConfig())
        .map(value => zio.aws.connect.model.KinesisFirehoseConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.InstanceStorageConfig
  ): zio.aws.connect.model.InstanceStorageConfig.ReadOnly = new Wrapper(impl)
}
