package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait IntegrationType {
  def unwrap: software.amazon.awssdk.services.connect.model.IntegrationType
}
object IntegrationType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.IntegrationType
  ): zio.aws.connect.model.IntegrationType = value match {
    case software.amazon.awssdk.services.connect.model.IntegrationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.IntegrationType.EVENT =>
      val r = EVENT
      r
    case software.amazon.awssdk.services.connect.model.IntegrationType.VOICE_ID =>
      val r = VOICE_ID
      r
    case software.amazon.awssdk.services.connect.model.IntegrationType.PINPOINT_APP =>
      val r = PINPOINT_APP
      r
    case software.amazon.awssdk.services.connect.model.IntegrationType.WISDOM_ASSISTANT =>
      val r = WISDOM_ASSISTANT
      r
    case software.amazon.awssdk.services.connect.model.IntegrationType.WISDOM_KNOWLEDGE_BASE =>
      val r = WISDOM_KNOWLEDGE_BASE
      r
    case software.amazon.awssdk.services.connect.model.IntegrationType.CASES_DOMAIN =>
      val r = CASES_DOMAIN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.IntegrationType =
      software.amazon.awssdk.services.connect.model.IntegrationType.UNKNOWN_TO_SDK_VERSION
  }
  case object EVENT extends zio.aws.connect.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.IntegrationType =
      software.amazon.awssdk.services.connect.model.IntegrationType.EVENT
  }
  case object VOICE_ID extends zio.aws.connect.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.IntegrationType =
      software.amazon.awssdk.services.connect.model.IntegrationType.VOICE_ID
  }
  case object PINPOINT_APP extends zio.aws.connect.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.IntegrationType =
      software.amazon.awssdk.services.connect.model.IntegrationType.PINPOINT_APP
  }
  case object WISDOM_ASSISTANT extends zio.aws.connect.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.IntegrationType =
      software.amazon.awssdk.services.connect.model.IntegrationType.WISDOM_ASSISTANT
  }
  case object WISDOM_KNOWLEDGE_BASE
      extends zio.aws.connect.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.IntegrationType =
      software.amazon.awssdk.services.connect.model.IntegrationType.WISDOM_KNOWLEDGE_BASE
  }
  case object CASES_DOMAIN extends zio.aws.connect.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.IntegrationType =
      software.amazon.awssdk.services.connect.model.IntegrationType.CASES_DOMAIN
  }
}
