package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InvisibleFieldInfo(
    id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.InvisibleFieldInfo = {
    import InvisibleFieldInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.InvisibleFieldInfo
      .builder()
      .optionallyWith(id.map(value => value.buildAwsValue()))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.InvisibleFieldInfo.ReadOnly =
    zio.aws.connect.model.InvisibleFieldInfo.wrap(buildAwsValue())
}
object InvisibleFieldInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.InvisibleFieldInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.InvisibleFieldInfo =
      zio.aws.connect.model
        .InvisibleFieldInfo(id.map(value => value.asEditable))
    def id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly]
    def getId: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.InvisibleFieldInfo
  ) extends zio.aws.connect.model.InvisibleFieldInfo.ReadOnly {
    override val id
        : Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.TaskTemplateFieldIdentifier.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.InvisibleFieldInfo
  ): zio.aws.connect.model.InvisibleFieldInfo.ReadOnly = new Wrapper(impl)
}
