package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class KinesisFirehoseConfig(firehoseArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.KinesisFirehoseConfig = {
    import KinesisFirehoseConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.KinesisFirehoseConfig
      .builder()
      .firehoseArn(ARN.unwrap(firehoseArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.KinesisFirehoseConfig.ReadOnly =
    zio.aws.connect.model.KinesisFirehoseConfig.wrap(buildAwsValue())
}
object KinesisFirehoseConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.KinesisFirehoseConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.KinesisFirehoseConfig =
      zio.aws.connect.model.KinesisFirehoseConfig(firehoseArn)
    def firehoseArn: ARN
    def getFirehoseArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(firehoseArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.KinesisFirehoseConfig
  ) extends zio.aws.connect.model.KinesisFirehoseConfig.ReadOnly {
    override val firehoseArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.firehoseArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.KinesisFirehoseConfig
  ): zio.aws.connect.model.KinesisFirehoseConfig.ReadOnly = new Wrapper(impl)
}
