package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class KinesisStreamConfig(streamArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.KinesisStreamConfig = {
    import KinesisStreamConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.KinesisStreamConfig
      .builder()
      .streamArn(ARN.unwrap(streamArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.KinesisStreamConfig.ReadOnly =
    zio.aws.connect.model.KinesisStreamConfig.wrap(buildAwsValue())
}
object KinesisStreamConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.KinesisStreamConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.KinesisStreamConfig =
      zio.aws.connect.model.KinesisStreamConfig(streamArn)
    def streamArn: ARN
    def getStreamArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(streamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.KinesisStreamConfig
  ) extends zio.aws.connect.model.KinesisStreamConfig.ReadOnly {
    override val streamArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.streamArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.KinesisStreamConfig
  ): zio.aws.connect.model.KinesisStreamConfig.ReadOnly = new Wrapper(impl)
}
