package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListContactFlowModulesResponse(
    contactFlowModulesSummaryList: Optional[
      Iterable[zio.aws.connect.model.ContactFlowModuleSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse = {
    import ListContactFlowModulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse
      .builder()
      .optionallyWith(
        contactFlowModulesSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contactFlowModulesSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly =
    zio.aws.connect.model.ListContactFlowModulesResponse.wrap(buildAwsValue())
}
object ListContactFlowModulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactFlowModulesResponse =
      zio.aws.connect.model.ListContactFlowModulesResponse(
        contactFlowModulesSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contactFlowModulesSummaryList: Optional[
      List[zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getContactFlowModulesSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "contactFlowModulesSummaryList",
      contactFlowModulesSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse
  ) extends zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly {
    override val contactFlowModulesSummaryList: Optional[
      List[zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contactFlowModulesSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.ContactFlowModuleSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse
  ): zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly =
    new Wrapper(impl)
}
