package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListContactReferencesResponse(
    referenceSummaryList: Optional[
      Iterable[zio.aws.connect.model.ReferenceSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactReferencesResponse = {
    import ListContactReferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
      .builder()
      .optionallyWith(
        referenceSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListContactReferencesResponse.ReadOnly =
    zio.aws.connect.model.ListContactReferencesResponse.wrap(buildAwsValue())
}
object ListContactReferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactReferencesResponse =
      zio.aws.connect.model.ListContactReferencesResponse(
        referenceSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def referenceSummaryList
        : Optional[List[zio.aws.connect.model.ReferenceSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getReferenceSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.ReferenceSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("referenceSummaryList", referenceSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
  ) extends zio.aws.connect.model.ListContactReferencesResponse.ReadOnly {
    override val referenceSummaryList
        : Optional[List[zio.aws.connect.model.ReferenceSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.ReferenceSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
  ): zio.aws.connect.model.ListContactReferencesResponse.ReadOnly = new Wrapper(
    impl
  )
}
