package zio.aws.connect.model
import zio.aws.connect.model.primitives.{MaxResult10, NextToken, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListInstanceStorageConfigsRequest(
    instanceId: InstanceId,
    resourceType: zio.aws.connect.model.InstanceStorageResourceType,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult10] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest = {
    import ListInstanceStorageConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult10.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListInstanceStorageConfigsRequest.ReadOnly =
    zio.aws.connect.model.ListInstanceStorageConfigsRequest
      .wrap(buildAwsValue())
}
object ListInstanceStorageConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListInstanceStorageConfigsRequest =
      zio.aws.connect.model.ListInstanceStorageConfigsRequest(
        instanceId,
        resourceType,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def resourceType: zio.aws.connect.model.InstanceStorageResourceType
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult10]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.connect.model.InstanceStorageResourceType] =
      ZIO.succeed(resourceType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult10] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest
  ) extends zio.aws.connect.model.ListInstanceStorageConfigsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val resourceType
        : zio.aws.connect.model.InstanceStorageResourceType =
      zio.aws.connect.model.InstanceStorageResourceType
        .wrap(impl.resourceType())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult10] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult10(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest
  ): zio.aws.connect.model.ListInstanceStorageConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
