package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListInstancesResponse(
    instanceSummaryList: Optional[
      Iterable[zio.aws.connect.model.InstanceSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListInstancesResponse = {
    import ListInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListInstancesResponse
      .builder()
      .optionallyWith(
        instanceSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListInstancesResponse.ReadOnly =
    zio.aws.connect.model.ListInstancesResponse.wrap(buildAwsValue())
}
object ListInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListInstancesResponse =
      zio.aws.connect.model.ListInstancesResponse(
        instanceSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceSummaryList
        : Optional[List[zio.aws.connect.model.InstanceSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getInstanceSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.InstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceSummaryList", instanceSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListInstancesResponse
  ) extends zio.aws.connect.model.ListInstancesResponse.ReadOnly {
    override val instanceSummaryList
        : Optional[List[zio.aws.connect.model.InstanceSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.InstanceSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListInstancesResponse
  ): zio.aws.connect.model.ListInstancesResponse.ReadOnly = new Wrapper(impl)
}
