package zio.aws.connect.model
import zio.aws.connect.model.primitives.{MaxResult1000, NextToken, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersRequest(
    instanceId: InstanceId,
    phoneNumberTypes: Optional[
      Iterable[zio.aws.connect.model.PhoneNumberType]
    ] = Optional.Absent,
    phoneNumberCountryCodes: Optional[
      Iterable[zio.aws.connect.model.PhoneNumberCountryCode]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult1000] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest = {
    import ListPhoneNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        phoneNumberTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.phoneNumberTypesWithStrings)
      .optionallyWith(
        phoneNumberCountryCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.phoneNumberCountryCodesWithStrings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult1000.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListPhoneNumbersRequest.ReadOnly =
    zio.aws.connect.model.ListPhoneNumbersRequest.wrap(buildAwsValue())
}
object ListPhoneNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListPhoneNumbersRequest =
      zio.aws.connect.model.ListPhoneNumbersRequest(
        instanceId,
        phoneNumberTypes.map(value => value),
        phoneNumberCountryCodes.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def phoneNumberTypes: Optional[List[zio.aws.connect.model.PhoneNumberType]]
    def phoneNumberCountryCodes
        : Optional[List[zio.aws.connect.model.PhoneNumberCountryCode]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult1000]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPhoneNumberTypes
        : ZIO[Any, AwsError, List[zio.aws.connect.model.PhoneNumberType]] =
      AwsError.unwrapOptionField("phoneNumberTypes", phoneNumberTypes)
    def getPhoneNumberCountryCodes: ZIO[Any, AwsError, List[
      zio.aws.connect.model.PhoneNumberCountryCode
    ]] = AwsError.unwrapOptionField(
      "phoneNumberCountryCodes",
      phoneNumberCountryCodes
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult1000] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest
  ) extends zio.aws.connect.model.ListPhoneNumbersRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val phoneNumberTypes
        : Optional[List[zio.aws.connect.model.PhoneNumberType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.PhoneNumberType.wrap(item)
          }.toList
        )
    override val phoneNumberCountryCodes
        : Optional[List[zio.aws.connect.model.PhoneNumberCountryCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberCountryCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.PhoneNumberCountryCode.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult1000] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult1000(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest
  ): zio.aws.connect.model.ListPhoneNumbersRequest.ReadOnly = new Wrapper(impl)
}
