package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{PhoneNumber, ARN, PhoneNumberId}
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersSummary(
    phoneNumberId: Optional[PhoneNumberId] = Optional.Absent,
    phoneNumberArn: Optional[ARN] = Optional.Absent,
    phoneNumber: Optional[PhoneNumber] = Optional.Absent,
    phoneNumberCountryCode: Optional[
      zio.aws.connect.model.PhoneNumberCountryCode
    ] = Optional.Absent,
    phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType] =
      Optional.Absent,
    targetArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary = {
    import ListPhoneNumbersSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary
      .builder()
      .optionallyWith(
        phoneNumberId.map(value =>
          PhoneNumberId.unwrap(value): java.lang.String
        )
      )(_.phoneNumberId)
      .optionallyWith(
        phoneNumberArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.phoneNumberArn)
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(phoneNumberCountryCode.map(value => value.unwrap))(
        _.phoneNumberCountryCode
      )
      .optionallyWith(phoneNumberType.map(value => value.unwrap))(
        _.phoneNumberType
      )
      .optionallyWith(
        targetArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.targetArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly =
    zio.aws.connect.model.ListPhoneNumbersSummary.wrap(buildAwsValue())
}
object ListPhoneNumbersSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListPhoneNumbersSummary =
      zio.aws.connect.model.ListPhoneNumbersSummary(
        phoneNumberId.map(value => value),
        phoneNumberArn.map(value => value),
        phoneNumber.map(value => value),
        phoneNumberCountryCode.map(value => value),
        phoneNumberType.map(value => value),
        targetArn.map(value => value)
      )
    def phoneNumberId: Optional[PhoneNumberId]
    def phoneNumberArn: Optional[ARN]
    def phoneNumber: Optional[PhoneNumber]
    def phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode]
    def phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType]
    def targetArn: Optional[ARN]
    def getPhoneNumberId: ZIO[Any, AwsError, PhoneNumberId] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getPhoneNumberArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("phoneNumberArn", phoneNumberArn)
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumberCountryCode
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberCountryCode] =
      AwsError.unwrapOptionField(
        "phoneNumberCountryCode",
        phoneNumberCountryCode
      )
    def getPhoneNumberType
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberType] =
      AwsError.unwrapOptionField("phoneNumberType", phoneNumberType)
    def getTargetArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("targetArn", targetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary
  ) extends zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly {
    override val phoneNumberId: Optional[PhoneNumberId] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberId())
      .map(value => zio.aws.connect.model.primitives.PhoneNumberId(value))
    override val phoneNumberArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val phoneNumber: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
    override val phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberCountryCode())
        .map(value => zio.aws.connect.model.PhoneNumberCountryCode.wrap(value))
    override val phoneNumberType
        : Optional[zio.aws.connect.model.PhoneNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberType())
        .map(value => zio.aws.connect.model.PhoneNumberType.wrap(value))
    override val targetArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary
  ): zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly = new Wrapper(impl)
}
