package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRoutingProfilesResponse(
    routingProfileSummaryList: Optional[
      Iterable[zio.aws.connect.model.RoutingProfileSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse = {
    import ListRoutingProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse
      .builder()
      .optionallyWith(
        routingProfileSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingProfileSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly =
    zio.aws.connect.model.ListRoutingProfilesResponse.wrap(buildAwsValue())
}
object ListRoutingProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListRoutingProfilesResponse =
      zio.aws.connect.model.ListRoutingProfilesResponse(
        routingProfileSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def routingProfileSummaryList
        : Optional[List[zio.aws.connect.model.RoutingProfileSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRoutingProfileSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.RoutingProfileSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "routingProfileSummaryList",
      routingProfileSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse
  ) extends zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly {
    override val routingProfileSummaryList
        : Optional[List[zio.aws.connect.model.RoutingProfileSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingProfileSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.RoutingProfileSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse
  ): zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly = new Wrapper(
    impl
  )
}
