package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListSecurityProfilesResponse(
    securityProfileSummaryList: Optional[
      Iterable[zio.aws.connect.model.SecurityProfileSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse = {
    import ListSecurityProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse
      .builder()
      .optionallyWith(
        securityProfileSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityProfileSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListSecurityProfilesResponse.ReadOnly =
    zio.aws.connect.model.ListSecurityProfilesResponse.wrap(buildAwsValue())
}
object ListSecurityProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListSecurityProfilesResponse =
      zio.aws.connect.model.ListSecurityProfilesResponse(
        securityProfileSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def securityProfileSummaryList
        : Optional[List[zio.aws.connect.model.SecurityProfileSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSecurityProfileSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.SecurityProfileSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityProfileSummaryList",
      securityProfileSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse
  ) extends zio.aws.connect.model.ListSecurityProfilesResponse.ReadOnly {
    override val securityProfileSummaryList: Optional[
      List[zio.aws.connect.model.SecurityProfileSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityProfileSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.SecurityProfileSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse
  ): zio.aws.connect.model.ListSecurityProfilesResponse.ReadOnly = new Wrapper(
    impl
  )
}
