package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  TaskTemplateName,
  MaxResult100,
  NextToken,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTaskTemplatesRequest(
    instanceId: InstanceId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent,
    status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      Optional.Absent,
    name: Optional[TaskTemplateName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest = {
    import ListTaskTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => TaskTemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListTaskTemplatesRequest.ReadOnly =
    zio.aws.connect.model.ListTaskTemplatesRequest.wrap(buildAwsValue())
}
object ListTaskTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListTaskTemplatesRequest =
      zio.aws.connect.model.ListTaskTemplatesRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value),
        name.map(value => value)
      )
    def instanceId: InstanceId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult100]
    def status: Optional[zio.aws.connect.model.TaskTemplateStatus]
    def name: Optional[TaskTemplateName]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.TaskTemplateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, TaskTemplateName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest
  ) extends zio.aws.connect.model.ListTaskTemplatesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
    override val status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.TaskTemplateStatus.wrap(value))
    override val name: Optional[TaskTemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest
  ): zio.aws.connect.model.ListTaskTemplatesRequest.ReadOnly = new Wrapper(impl)
}
