package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  InstanceIdOrArn,
  NextToken,
  MaxResult10
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTrafficDistributionGroupsRequest(
    maxResults: Optional[MaxResult10] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    instanceId: Optional[InstanceIdOrArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest = {
    import ListTrafficDistributionGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResult10.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        instanceId.map(value => InstanceIdOrArn.unwrap(value): java.lang.String)
      )(_.instanceId)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListTrafficDistributionGroupsRequest.ReadOnly =
    zio.aws.connect.model.ListTrafficDistributionGroupsRequest
      .wrap(buildAwsValue())
}
object ListTrafficDistributionGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListTrafficDistributionGroupsRequest =
      zio.aws.connect.model.ListTrafficDistributionGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        instanceId.map(value => value)
      )
    def maxResults: Optional[MaxResult10]
    def nextToken: Optional[NextToken]
    def instanceId: Optional[InstanceIdOrArn]
    def getMaxResults: ZIO[Any, AwsError, MaxResult10] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInstanceId: ZIO[Any, AwsError, InstanceIdOrArn] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest
  ) extends zio.aws.connect.model.ListTrafficDistributionGroupsRequest.ReadOnly {
    override val maxResults: Optional[MaxResult10] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult10(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val instanceId: Optional[InstanceIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.connect.model.primitives.InstanceIdOrArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest
  ): zio.aws.connect.model.ListTrafficDistributionGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
