package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListTrafficDistributionGroupsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    trafficDistributionGroupSummaryList: Optional[
      Iterable[zio.aws.connect.model.TrafficDistributionGroupSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse = {
    import ListTrafficDistributionGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        trafficDistributionGroupSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trafficDistributionGroupSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly =
    zio.aws.connect.model.ListTrafficDistributionGroupsResponse
      .wrap(buildAwsValue())
}
object ListTrafficDistributionGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.ListTrafficDistributionGroupsResponse =
      zio.aws.connect.model.ListTrafficDistributionGroupsResponse(
        nextToken.map(value => value),
        trafficDistributionGroupSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def trafficDistributionGroupSummaryList: Optional[
      List[zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrafficDistributionGroupSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trafficDistributionGroupSummaryList",
      trafficDistributionGroupSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse
  ) extends zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val trafficDistributionGroupSummaryList: Optional[
      List[zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficDistributionGroupSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.TrafficDistributionGroupSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse
  ): zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
