package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListUseCasesResponse(
    useCaseSummaryList: Optional[Iterable[zio.aws.connect.model.UseCase]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListUseCasesResponse = {
    import ListUseCasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListUseCasesResponse
      .builder()
      .optionallyWith(
        useCaseSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.useCaseSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListUseCasesResponse.ReadOnly =
    zio.aws.connect.model.ListUseCasesResponse.wrap(buildAwsValue())
}
object ListUseCasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListUseCasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListUseCasesResponse =
      zio.aws.connect.model.ListUseCasesResponse(
        useCaseSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def useCaseSummaryList
        : Optional[List[zio.aws.connect.model.UseCase.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getUseCaseSummaryList
        : ZIO[Any, AwsError, List[zio.aws.connect.model.UseCase.ReadOnly]] =
      AwsError.unwrapOptionField("useCaseSummaryList", useCaseSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListUseCasesResponse
  ) extends zio.aws.connect.model.ListUseCasesResponse.ReadOnly {
    override val useCaseSummaryList
        : Optional[List[zio.aws.connect.model.UseCase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useCaseSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.UseCase.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListUseCasesResponse
  ): zio.aws.connect.model.ListUseCasesResponse.ReadOnly = new Wrapper(impl)
}
