package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.Concurrency
import scala.jdk.CollectionConverters._
final case class MediaConcurrency(
    channel: zio.aws.connect.model.Channel,
    concurrency: Concurrency
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MediaConcurrency = {
    import MediaConcurrency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MediaConcurrency
      .builder()
      .channel(channel.unwrap)
      .concurrency(Concurrency.unwrap(concurrency): Integer)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MediaConcurrency.ReadOnly =
    zio.aws.connect.model.MediaConcurrency.wrap(buildAwsValue())
}
object MediaConcurrency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.MediaConcurrency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MediaConcurrency =
      zio.aws.connect.model.MediaConcurrency(channel, concurrency)
    def channel: zio.aws.connect.model.Channel
    def concurrency: Concurrency
    def getChannel: ZIO[Any, Nothing, zio.aws.connect.model.Channel] =
      ZIO.succeed(channel)
    def getConcurrency: ZIO[Any, Nothing, Concurrency] =
      ZIO.succeed(concurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MediaConcurrency
  ) extends zio.aws.connect.model.MediaConcurrency.ReadOnly {
    override val channel: zio.aws.connect.model.Channel =
      zio.aws.connect.model.Channel.wrap(impl.channel())
    override val concurrency: Concurrency =
      zio.aws.connect.model.primitives.Concurrency(impl.concurrency())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MediaConcurrency
  ): zio.aws.connect.model.MediaConcurrency.ReadOnly = new Wrapper(impl)
}
