package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.DisplayName
import scala.jdk.CollectionConverters._
final case class ParticipantDetails(displayName: DisplayName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ParticipantDetails = {
    import ParticipantDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ParticipantDetails
      .builder()
      .displayName(DisplayName.unwrap(displayName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ParticipantDetails.ReadOnly =
    zio.aws.connect.model.ParticipantDetails.wrap(buildAwsValue())
}
object ParticipantDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ParticipantDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ParticipantDetails =
      zio.aws.connect.model.ParticipantDetails(displayName)
    def displayName: DisplayName
    def getDisplayName: ZIO[Any, Nothing, DisplayName] =
      ZIO.succeed(displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ParticipantDetails
  ) extends zio.aws.connect.model.ParticipantDetails.ReadOnly {
    override val displayName: DisplayName =
      zio.aws.connect.model.primitives.DisplayName(impl.displayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ParticipantDetails
  ): zio.aws.connect.model.ParticipantDetails.ReadOnly = new Wrapper(impl)
}
