package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.PhoneNumberWorkflowMessage
import scala.jdk.CollectionConverters._
final case class PhoneNumberStatus(
    status: Optional[zio.aws.connect.model.PhoneNumberWorkflowStatus] =
      Optional.Absent,
    message: Optional[PhoneNumberWorkflowMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PhoneNumberStatus = {
    import PhoneNumberStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PhoneNumberStatus
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value =>
          PhoneNumberWorkflowMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PhoneNumberStatus.ReadOnly =
    zio.aws.connect.model.PhoneNumberStatus.wrap(buildAwsValue())
}
object PhoneNumberStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PhoneNumberStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PhoneNumberStatus =
      zio.aws.connect.model.PhoneNumberStatus(
        status.map(value => value),
        message.map(value => value)
      )
    def status: Optional[zio.aws.connect.model.PhoneNumberWorkflowStatus]
    def message: Optional[PhoneNumberWorkflowMessage]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberWorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, PhoneNumberWorkflowMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberStatus
  ) extends zio.aws.connect.model.PhoneNumberStatus.ReadOnly {
    override val status
        : Optional[zio.aws.connect.model.PhoneNumberWorkflowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.connect.model.PhoneNumberWorkflowStatus.wrap(value)
        )
    override val message: Optional[PhoneNumberWorkflowMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.connect.model.primitives.PhoneNumberWorkflowMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberStatus
  ): zio.aws.connect.model.PhoneNumberStatus.ReadOnly = new Wrapper(impl)
}
