package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{PhoneNumber, ARN, PhoneNumberId}
import scala.jdk.CollectionConverters._
final case class PhoneNumberSummary(
    id: Optional[PhoneNumberId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    phoneNumber: Optional[PhoneNumber] = Optional.Absent,
    phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType] =
      Optional.Absent,
    phoneNumberCountryCode: Optional[
      zio.aws.connect.model.PhoneNumberCountryCode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PhoneNumberSummary = {
    import PhoneNumberSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PhoneNumberSummary
      .builder()
      .optionallyWith(
        id.map(value => PhoneNumberId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(phoneNumberType.map(value => value.unwrap))(
        _.phoneNumberType
      )
      .optionallyWith(phoneNumberCountryCode.map(value => value.unwrap))(
        _.phoneNumberCountryCode
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PhoneNumberSummary.ReadOnly =
    zio.aws.connect.model.PhoneNumberSummary.wrap(buildAwsValue())
}
object PhoneNumberSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PhoneNumberSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PhoneNumberSummary =
      zio.aws.connect.model.PhoneNumberSummary(
        id.map(value => value),
        arn.map(value => value),
        phoneNumber.map(value => value),
        phoneNumberType.map(value => value),
        phoneNumberCountryCode.map(value => value)
      )
    def id: Optional[PhoneNumberId]
    def arn: Optional[ARN]
    def phoneNumber: Optional[PhoneNumber]
    def phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType]
    def phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode]
    def getId: ZIO[Any, AwsError, PhoneNumberId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumberType
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberType] =
      AwsError.unwrapOptionField("phoneNumberType", phoneNumberType)
    def getPhoneNumberCountryCode
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberCountryCode] =
      AwsError.unwrapOptionField(
        "phoneNumberCountryCode",
        phoneNumberCountryCode
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberSummary
  ) extends zio.aws.connect.model.PhoneNumberSummary.ReadOnly {
    override val id: Optional[PhoneNumberId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.PhoneNumberId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val phoneNumber: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
    override val phoneNumberType
        : Optional[zio.aws.connect.model.PhoneNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberType())
        .map(value => zio.aws.connect.model.PhoneNumberType.wrap(value))
    override val phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberCountryCode())
        .map(value => zio.aws.connect.model.PhoneNumberCountryCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberSummary
  ): zio.aws.connect.model.PhoneNumberSummary.ReadOnly = new Wrapper(impl)
}
