package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{AgentStatusId, InstanceId, UserId}
import scala.jdk.CollectionConverters._
final case class PutUserStatusRequest(
    userId: UserId,
    instanceId: InstanceId,
    agentStatusId: AgentStatusId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PutUserStatusRequest = {
    import PutUserStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PutUserStatusRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .agentStatusId(AgentStatusId.unwrap(agentStatusId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PutUserStatusRequest.ReadOnly =
    zio.aws.connect.model.PutUserStatusRequest.wrap(buildAwsValue())
}
object PutUserStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PutUserStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PutUserStatusRequest =
      zio.aws.connect.model
        .PutUserStatusRequest(userId, instanceId, agentStatusId)
    def userId: UserId
    def instanceId: InstanceId
    def agentStatusId: AgentStatusId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAgentStatusId: ZIO[Any, Nothing, AgentStatusId] =
      ZIO.succeed(agentStatusId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PutUserStatusRequest
  ) extends zio.aws.connect.model.PutUserStatusRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val agentStatusId: AgentStatusId =
      zio.aws.connect.model.primitives.AgentStatusId(impl.agentStatusId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PutUserStatusRequest
  ): zio.aws.connect.model.PutUserStatusRequest.ReadOnly = new Wrapper(impl)
}
