package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueueSearchCriteria(
    orConditions: Optional[
      Iterable[zio.aws.connect.model.QueueSearchCriteria]
    ] = Optional.Absent,
    andConditions: Optional[
      Iterable[zio.aws.connect.model.QueueSearchCriteria]
    ] = Optional.Absent,
    stringCondition: Optional[zio.aws.connect.model.StringCondition] =
      Optional.Absent,
    queueTypeCondition: Optional[zio.aws.connect.model.SearchableQueueType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QueueSearchCriteria = {
    import QueueSearchCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QueueSearchCriteria
      .builder()
      .optionallyWith(
        orConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orConditions)
      .optionallyWith(
        andConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andConditions)
      .optionallyWith(stringCondition.map(value => value.buildAwsValue()))(
        _.stringCondition
      )
      .optionallyWith(queueTypeCondition.map(value => value.unwrap))(
        _.queueTypeCondition
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QueueSearchCriteria.ReadOnly =
    zio.aws.connect.model.QueueSearchCriteria.wrap(buildAwsValue())
}
object QueueSearchCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QueueSearchCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QueueSearchCriteria =
      zio.aws.connect.model.QueueSearchCriteria(
        orConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        andConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stringCondition.map(value => value.asEditable),
        queueTypeCondition.map(value => value)
      )
    def orConditions
        : Optional[List[zio.aws.connect.model.QueueSearchCriteria.ReadOnly]]
    def andConditions
        : Optional[List[zio.aws.connect.model.QueueSearchCriteria.ReadOnly]]
    def stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly]
    def queueTypeCondition: Optional[zio.aws.connect.model.SearchableQueueType]
    def getOrConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.QueueSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("orConditions", orConditions)
    def getAndConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.QueueSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("andConditions", andConditions)
    def getStringCondition
        : ZIO[Any, AwsError, zio.aws.connect.model.StringCondition.ReadOnly] =
      AwsError.unwrapOptionField("stringCondition", stringCondition)
    def getQueueTypeCondition
        : ZIO[Any, AwsError, zio.aws.connect.model.SearchableQueueType] =
      AwsError.unwrapOptionField("queueTypeCondition", queueTypeCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QueueSearchCriteria
  ) extends zio.aws.connect.model.QueueSearchCriteria.ReadOnly {
    override val orConditions
        : Optional[List[zio.aws.connect.model.QueueSearchCriteria.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QueueSearchCriteria.wrap(item)
          }.toList
        )
    override val andConditions
        : Optional[List[zio.aws.connect.model.QueueSearchCriteria.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.andConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QueueSearchCriteria.wrap(item)
          }.toList
        )
    override val stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringCondition())
        .map(value => zio.aws.connect.model.StringCondition.wrap(value))
    override val queueTypeCondition
        : Optional[zio.aws.connect.model.SearchableQueueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueTypeCondition())
        .map(value => zio.aws.connect.model.SearchableQueueType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QueueSearchCriteria
  ): zio.aws.connect.model.QueueSearchCriteria.ReadOnly = new Wrapper(impl)
}
