package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{QueueName, ARN, QueueId}
import scala.jdk.CollectionConverters._
final case class QueueSummary(
    id: Optional[QueueId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[QueueName] = Optional.Absent,
    queueType: Optional[zio.aws.connect.model.QueueType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QueueSummary = {
    import QueueSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QueueSummary
      .builder()
      .optionallyWith(id.map(value => QueueId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => QueueName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(queueType.map(value => value.unwrap))(_.queueType)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QueueSummary.ReadOnly =
    zio.aws.connect.model.QueueSummary.wrap(buildAwsValue())
}
object QueueSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QueueSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QueueSummary =
      zio.aws.connect.model.QueueSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        queueType.map(value => value)
      )
    def id: Optional[QueueId]
    def arn: Optional[ARN]
    def name: Optional[QueueName]
    def queueType: Optional[zio.aws.connect.model.QueueType]
    def getId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, QueueName] =
      AwsError.unwrapOptionField("name", name)
    def getQueueType: ZIO[Any, AwsError, zio.aws.connect.model.QueueType] =
      AwsError.unwrapOptionField("queueType", queueType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QueueSummary
  ) extends zio.aws.connect.model.QueueSummary.ReadOnly {
    override val id: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[QueueName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.QueueName(value))
    override val queueType: Optional[zio.aws.connect.model.QueueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueType())
        .map(value => zio.aws.connect.model.QueueType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QueueSummary
  ): zio.aws.connect.model.QueueSummary.ReadOnly = new Wrapper(impl)
}
