package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait QueueType {
  def unwrap: software.amazon.awssdk.services.connect.model.QueueType
}
object QueueType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.QueueType
  ): zio.aws.connect.model.QueueType = value match {
    case software.amazon.awssdk.services.connect.model.QueueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.QueueType.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.connect.model.QueueType.AGENT =>
      val r = AGENT
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.QueueType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QueueType =
      software.amazon.awssdk.services.connect.model.QueueType.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.connect.model.QueueType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QueueType =
      software.amazon.awssdk.services.connect.model.QueueType.STANDARD
  }
  case object AGENT extends zio.aws.connect.model.QueueType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QueueType =
      software.amazon.awssdk.services.connect.model.QueueType.AGENT
  }
}
