package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReadOnlyFieldInfo(
    id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ReadOnlyFieldInfo = {
    import ReadOnlyFieldInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ReadOnlyFieldInfo
      .builder()
      .optionallyWith(id.map(value => value.buildAwsValue()))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ReadOnlyFieldInfo.ReadOnly =
    zio.aws.connect.model.ReadOnlyFieldInfo.wrap(buildAwsValue())
}
object ReadOnlyFieldInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ReadOnlyFieldInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ReadOnlyFieldInfo =
      zio.aws.connect.model.ReadOnlyFieldInfo(id.map(value => value.asEditable))
    def id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly]
    def getId: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ReadOnlyFieldInfo
  ) extends zio.aws.connect.model.ReadOnlyFieldInfo.ReadOnly {
    override val id
        : Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.TaskTemplateFieldIdentifier.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ReadOnlyFieldInfo
  ): zio.aws.connect.model.ReadOnlyFieldInfo.ReadOnly = new Wrapper(impl)
}
