package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.ReferenceValue
import scala.jdk.CollectionConverters._
final case class Reference(
    value: ReferenceValue,
    `type`: zio.aws.connect.model.ReferenceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Reference = {
    import Reference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Reference
      .builder()
      .value(ReferenceValue.unwrap(value): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Reference.ReadOnly =
    zio.aws.connect.model.Reference.wrap(buildAwsValue())
}
object Reference {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Reference] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Reference =
      zio.aws.connect.model.Reference(value, `type`)
    def value: ReferenceValue
    def `type`: zio.aws.connect.model.ReferenceType
    def getValue: ZIO[Any, Nothing, ReferenceValue] = ZIO.succeed(value)
    def getType: ZIO[Any, Nothing, zio.aws.connect.model.ReferenceType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Reference
  ) extends zio.aws.connect.model.Reference.ReadOnly {
    override val value: ReferenceValue =
      zio.aws.connect.model.primitives.ReferenceValue(impl.value())
    override val `type`: zio.aws.connect.model.ReferenceType =
      zio.aws.connect.model.ReferenceType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Reference
  ): zio.aws.connect.model.Reference.ReadOnly = new Wrapper(impl)
}
