package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReferenceSummary(
    url: Optional[zio.aws.connect.model.UrlReference] = Optional.Absent,
    attachment: Optional[zio.aws.connect.model.AttachmentReference] =
      Optional.Absent,
    string: Optional[zio.aws.connect.model.StringReference] = Optional.Absent,
    number: Optional[zio.aws.connect.model.NumberReference] = Optional.Absent,
    date: Optional[zio.aws.connect.model.DateReference] = Optional.Absent,
    email: Optional[zio.aws.connect.model.EmailReference] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ReferenceSummary = {
    import ReferenceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ReferenceSummary
      .builder()
      .optionallyWith(url.map(value => value.buildAwsValue()))(_.url)
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(string.map(value => value.buildAwsValue()))(_.string)
      .optionallyWith(number.map(value => value.buildAwsValue()))(_.number)
      .optionallyWith(date.map(value => value.buildAwsValue()))(_.date)
      .optionallyWith(email.map(value => value.buildAwsValue()))(_.email)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ReferenceSummary.ReadOnly =
    zio.aws.connect.model.ReferenceSummary.wrap(buildAwsValue())
}
object ReferenceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ReferenceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ReferenceSummary =
      zio.aws.connect.model.ReferenceSummary(
        url.map(value => value.asEditable),
        attachment.map(value => value.asEditable),
        string.map(value => value.asEditable),
        number.map(value => value.asEditable),
        date.map(value => value.asEditable),
        email.map(value => value.asEditable)
      )
    def url: Optional[zio.aws.connect.model.UrlReference.ReadOnly]
    def attachment: Optional[zio.aws.connect.model.AttachmentReference.ReadOnly]
    def string: Optional[zio.aws.connect.model.StringReference.ReadOnly]
    def number: Optional[zio.aws.connect.model.NumberReference.ReadOnly]
    def date: Optional[zio.aws.connect.model.DateReference.ReadOnly]
    def email: Optional[zio.aws.connect.model.EmailReference.ReadOnly]
    def getUrl
        : ZIO[Any, AwsError, zio.aws.connect.model.UrlReference.ReadOnly] =
      AwsError.unwrapOptionField("url", url)
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.AttachmentReference.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getString
        : ZIO[Any, AwsError, zio.aws.connect.model.StringReference.ReadOnly] =
      AwsError.unwrapOptionField("string", string)
    def getNumber
        : ZIO[Any, AwsError, zio.aws.connect.model.NumberReference.ReadOnly] =
      AwsError.unwrapOptionField("number", number)
    def getDate
        : ZIO[Any, AwsError, zio.aws.connect.model.DateReference.ReadOnly] =
      AwsError.unwrapOptionField("date", date)
    def getEmail
        : ZIO[Any, AwsError, zio.aws.connect.model.EmailReference.ReadOnly] =
      AwsError.unwrapOptionField("email", email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ReferenceSummary
  ) extends zio.aws.connect.model.ReferenceSummary.ReadOnly {
    override val url: Optional[zio.aws.connect.model.UrlReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.url())
        .map(value => zio.aws.connect.model.UrlReference.wrap(value))
    override val attachment
        : Optional[zio.aws.connect.model.AttachmentReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachment())
        .map(value => zio.aws.connect.model.AttachmentReference.wrap(value))
    override val string
        : Optional[zio.aws.connect.model.StringReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.string())
        .map(value => zio.aws.connect.model.StringReference.wrap(value))
    override val number
        : Optional[zio.aws.connect.model.NumberReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.number())
        .map(value => zio.aws.connect.model.NumberReference.wrap(value))
    override val date: Optional[zio.aws.connect.model.DateReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.date())
        .map(value => zio.aws.connect.model.DateReference.wrap(value))
    override val email
        : Optional[zio.aws.connect.model.EmailReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.email())
        .map(value => zio.aws.connect.model.EmailReference.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ReferenceSummary
  ): zio.aws.connect.model.ReferenceSummary.ReadOnly = new Wrapper(impl)
}
