package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ClientToken, PhoneNumberId}
import scala.jdk.CollectionConverters._
final case class ReleasePhoneNumberRequest(
    phoneNumberId: PhoneNumberId,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest = {
    import ReleasePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest
      .builder()
      .phoneNumberId(PhoneNumberId.unwrap(phoneNumberId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ReleasePhoneNumberRequest.ReadOnly =
    zio.aws.connect.model.ReleasePhoneNumberRequest.wrap(buildAwsValue())
}
object ReleasePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ReleasePhoneNumberRequest =
      zio.aws.connect.model.ReleasePhoneNumberRequest(
        phoneNumberId,
        clientToken.map(value => value)
      )
    def phoneNumberId: PhoneNumberId
    def clientToken: Optional[ClientToken]
    def getPhoneNumberId: ZIO[Any, Nothing, PhoneNumberId] =
      ZIO.succeed(phoneNumberId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest
  ) extends zio.aws.connect.model.ReleasePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: PhoneNumberId =
      zio.aws.connect.model.primitives.PhoneNumberId(impl.phoneNumberId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest
  ): zio.aws.connect.model.ReleasePhoneNumberRequest.ReadOnly = new Wrapper(
    impl
  )
}
