package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequiredFieldInfo(
    id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RequiredFieldInfo = {
    import RequiredFieldInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RequiredFieldInfo
      .builder()
      .optionallyWith(id.map(value => value.buildAwsValue()))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RequiredFieldInfo.ReadOnly =
    zio.aws.connect.model.RequiredFieldInfo.wrap(buildAwsValue())
}
object RequiredFieldInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RequiredFieldInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RequiredFieldInfo =
      zio.aws.connect.model.RequiredFieldInfo(id.map(value => value.asEditable))
    def id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly]
    def getId: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RequiredFieldInfo
  ) extends zio.aws.connect.model.RequiredFieldInfo.ReadOnly {
    override val id
        : Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.TaskTemplateFieldIdentifier.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RequiredFieldInfo
  ): zio.aws.connect.model.RequiredFieldInfo.ReadOnly = new Wrapper(impl)
}
