package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  Delay,
  QueueId,
  Priority,
  QueueName,
  ARN
}
import scala.jdk.CollectionConverters._
final case class RoutingProfileQueueConfigSummary(
    queueId: QueueId,
    queueArn: ARN,
    queueName: QueueName,
    priority: Priority,
    delay: Delay,
    channel: zio.aws.connect.model.Channel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary = {
    import RoutingProfileQueueConfigSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary
      .builder()
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .queueArn(ARN.unwrap(queueArn): java.lang.String)
      .queueName(QueueName.unwrap(queueName): java.lang.String)
      .priority(Priority.unwrap(priority): Integer)
      .delay(Delay.unwrap(delay): Integer)
      .channel(channel.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly =
    zio.aws.connect.model.RoutingProfileQueueConfigSummary.wrap(buildAwsValue())
}
object RoutingProfileQueueConfigSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RoutingProfileQueueConfigSummary =
      zio.aws.connect.model.RoutingProfileQueueConfigSummary(
        queueId,
        queueArn,
        queueName,
        priority,
        delay,
        channel
      )
    def queueId: QueueId
    def queueArn: ARN
    def queueName: QueueName
    def priority: Priority
    def delay: Delay
    def channel: zio.aws.connect.model.Channel
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getQueueArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(queueArn)
    def getQueueName: ZIO[Any, Nothing, QueueName] = ZIO.succeed(queueName)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
    def getDelay: ZIO[Any, Nothing, Delay] = ZIO.succeed(delay)
    def getChannel: ZIO[Any, Nothing, zio.aws.connect.model.Channel] =
      ZIO.succeed(channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary
  ) extends zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly {
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val queueArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.queueArn())
    override val queueName: QueueName =
      zio.aws.connect.model.primitives.QueueName(impl.queueName())
    override val priority: Priority =
      zio.aws.connect.model.primitives.Priority(impl.priority())
    override val delay: Delay =
      zio.aws.connect.model.primitives.Delay(impl.delay())
    override val channel: zio.aws.connect.model.Channel =
      zio.aws.connect.model.Channel.wrap(impl.channel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary
  ): zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly =
    new Wrapper(impl)
}
