package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, RoutingProfileId}
import scala.jdk.CollectionConverters._
final case class RoutingProfileReference(
    id: Optional[RoutingProfileId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RoutingProfileReference = {
    import RoutingProfileReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RoutingProfileReference
      .builder()
      .optionallyWith(
        id.map(value => RoutingProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RoutingProfileReference.ReadOnly =
    zio.aws.connect.model.RoutingProfileReference.wrap(buildAwsValue())
}
object RoutingProfileReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RoutingProfileReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RoutingProfileReference =
      zio.aws.connect.model.RoutingProfileReference(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[RoutingProfileId]
    def arn: Optional[ARN]
    def getId: ZIO[Any, AwsError, RoutingProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileReference
  ) extends zio.aws.connect.model.RoutingProfileReference.ReadOnly {
    override val id: Optional[RoutingProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileReference
  ): zio.aws.connect.model.RoutingProfileReference.ReadOnly = new Wrapper(impl)
}
