package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  RoutingProfileName,
  ARN,
  RoutingProfileId
}
import scala.jdk.CollectionConverters._
final case class RoutingProfileSummary(
    id: Optional[RoutingProfileId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[RoutingProfileName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RoutingProfileSummary = {
    import RoutingProfileSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RoutingProfileSummary
      .builder()
      .optionallyWith(
        id.map(value => RoutingProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => RoutingProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RoutingProfileSummary.ReadOnly =
    zio.aws.connect.model.RoutingProfileSummary.wrap(buildAwsValue())
}
object RoutingProfileSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RoutingProfileSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RoutingProfileSummary =
      zio.aws.connect.model.RoutingProfileSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Optional[RoutingProfileId]
    def arn: Optional[ARN]
    def name: Optional[RoutingProfileName]
    def getId: ZIO[Any, AwsError, RoutingProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, RoutingProfileName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileSummary
  ) extends zio.aws.connect.model.RoutingProfileSummary.ReadOnly {
    override val id: Optional[RoutingProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[RoutingProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileSummary
  ): zio.aws.connect.model.RoutingProfileSummary.ReadOnly = new Wrapper(impl)
}
