package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{Prefix, BucketName}
import scala.jdk.CollectionConverters._
final case class S3Config(
    bucketName: BucketName,
    bucketPrefix: Prefix,
    encryptionConfig: Optional[zio.aws.connect.model.EncryptionConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.S3Config = {
    import S3Config.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.S3Config
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .bucketPrefix(Prefix.unwrap(bucketPrefix): java.lang.String)
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.S3Config.ReadOnly =
    zio.aws.connect.model.S3Config.wrap(buildAwsValue())
}
object S3Config {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.S3Config] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.S3Config =
      zio.aws.connect.model.S3Config(
        bucketName,
        bucketPrefix,
        encryptionConfig.map(value => value.asEditable)
      )
    def bucketName: BucketName
    def bucketPrefix: Prefix
    def encryptionConfig
        : Optional[zio.aws.connect.model.EncryptionConfig.ReadOnly]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getBucketPrefix: ZIO[Any, Nothing, Prefix] = ZIO.succeed(bucketPrefix)
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.S3Config
  ) extends zio.aws.connect.model.S3Config.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.connect.model.primitives.BucketName(impl.bucketName())
    override val bucketPrefix: Prefix =
      zio.aws.connect.model.primitives.Prefix(impl.bucketPrefix())
    override val encryptionConfig
        : Optional[zio.aws.connect.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.connect.model.EncryptionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.S3Config
  ): zio.aws.connect.model.S3Config.ReadOnly = new Wrapper(impl)
}
