package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  LargeNextToken,
  MaxResult10,
  PhoneNumberPrefix,
  ARN
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchAvailablePhoneNumbersRequest(
    targetArn: ARN,
    phoneNumberCountryCode: zio.aws.connect.model.PhoneNumberCountryCode,
    phoneNumberType: zio.aws.connect.model.PhoneNumberType,
    phoneNumberPrefix: Optional[PhoneNumberPrefix] = Optional.Absent,
    maxResults: Optional[MaxResult10] = Optional.Absent,
    nextToken: Optional[LargeNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest = {
    import SearchAvailablePhoneNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest
      .builder()
      .targetArn(ARN.unwrap(targetArn): java.lang.String)
      .phoneNumberCountryCode(phoneNumberCountryCode.unwrap)
      .phoneNumberType(phoneNumberType.unwrap)
      .optionallyWith(
        phoneNumberPrefix.map(value =>
          PhoneNumberPrefix.unwrap(value): java.lang.String
        )
      )(_.phoneNumberPrefix)
      .optionallyWith(
        maxResults.map(value => MaxResult10.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => LargeNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SearchAvailablePhoneNumbersRequest.ReadOnly =
    zio.aws.connect.model.SearchAvailablePhoneNumbersRequest
      .wrap(buildAwsValue())
}
object SearchAvailablePhoneNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchAvailablePhoneNumbersRequest =
      zio.aws.connect.model.SearchAvailablePhoneNumbersRequest(
        targetArn,
        phoneNumberCountryCode,
        phoneNumberType,
        phoneNumberPrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def targetArn: ARN
    def phoneNumberCountryCode: zio.aws.connect.model.PhoneNumberCountryCode
    def phoneNumberType: zio.aws.connect.model.PhoneNumberType
    def phoneNumberPrefix: Optional[PhoneNumberPrefix]
    def maxResults: Optional[MaxResult10]
    def nextToken: Optional[LargeNextToken]
    def getTargetArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(targetArn)
    def getPhoneNumberCountryCode
        : ZIO[Any, Nothing, zio.aws.connect.model.PhoneNumberCountryCode] =
      ZIO.succeed(phoneNumberCountryCode)
    def getPhoneNumberType
        : ZIO[Any, Nothing, zio.aws.connect.model.PhoneNumberType] =
      ZIO.succeed(phoneNumberType)
    def getPhoneNumberPrefix: ZIO[Any, AwsError, PhoneNumberPrefix] =
      AwsError.unwrapOptionField("phoneNumberPrefix", phoneNumberPrefix)
    def getMaxResults: ZIO[Any, AwsError, MaxResult10] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, LargeNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest
  ) extends zio.aws.connect.model.SearchAvailablePhoneNumbersRequest.ReadOnly {
    override val targetArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.targetArn())
    override val phoneNumberCountryCode
        : zio.aws.connect.model.PhoneNumberCountryCode =
      zio.aws.connect.model.PhoneNumberCountryCode
        .wrap(impl.phoneNumberCountryCode())
    override val phoneNumberType: zio.aws.connect.model.PhoneNumberType =
      zio.aws.connect.model.PhoneNumberType.wrap(impl.phoneNumberType())
    override val phoneNumberPrefix: Optional[PhoneNumberPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberPrefix())
        .map(value => zio.aws.connect.model.primitives.PhoneNumberPrefix(value))
    override val maxResults: Optional[MaxResult10] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult10(value))
    override val nextToken: Optional[LargeNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.LargeNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest
  ): zio.aws.connect.model.SearchAvailablePhoneNumbersRequest.ReadOnly =
    new Wrapper(impl)
}
